<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van PRPM_IN908100NL0202 - Add New Qualified Application Role to Application, Request</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <pattern is-a="transmission-wrapper" id="PRPM_IN908100NL02-wrapper">
        <param name="element" value="hl7:PRPM_IN908100NL02"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="PRPM_IN908100NL02-controlAct">
        <param name="element" value="hl7:PRPM_IN908100NL02/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:PRPM_IN908100NL02/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:PRPM_IN908100NL02/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:PRPM_IN908100NL02/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- sender -->
        <rule context="hl7:PRPM_IN908100NL02/hl7:sender/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De zender van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
        <!-- receiver -->
        <rule context="hl7:PRPM_IN908100NL02/hl7:receiver/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en moet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/QualifiedApplicationRole</title>
        <rule context="hl7:subject/hl7:QualifiedApplicationRole/hl7:code">
            <extends rule="CE"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.3.11.3'"
                >QualifiedApplicationRole/code moet komen uit '2.16.840.1.113883.2.4.3.11.3'</assert>
        </rule>
        <rule context="hl7:subject/hl7:QualifiedApplicationRole/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error"
                test="@code='active' or @code='suspended'"
                >QualifiedApplicationRole/statusCode mag alleen 'active' of 'suspended' bevatten</assert>
            <assert role="error" test="if (@code='active') then (../hl7:subjectOf2) else (1=1)"
                >Als QualifiedApplicationRole/statusCode 'active' bevat, dan moet er ook een XIS-typekwalificatie zijn</assert>
            <assert role="error" test="if (@code='suspended') then (../hl7:subjectOf1) else (not(../hl7:subjectOf1))"
                >Als QualifiedApplicationRole/statusCode 'suspended' bevat, dan moet er ook een reden zijn, anders kan er geen reden zijn.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/QualifiedApplicationRole/subjectOf1/detectedIssueEvent</title>
        <rule context="hl7:subject/hl7:QualifiedApplicationRole/hl7:subjectOf1/hl7:detectedIssueEvent/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.5.4'"
                >detectedIssueEvent/code moet komen uit '2.16.840.1.113883.5.4' (ActCode)</assert>
            <assert role="error" test="@code='ISSUEMNT' or @code='ISSUEPRB'"
                >detectedIssueEvent/code moet één van ISSUEMNT ISSUEPRB zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/QualifiedApplicationRole/subjectOf2/verficationEvent</title>
        <rule context="hl7:subject/hl7:QualifiedApplicationRole/hl7:subjectOf2/hl7:verficationEvent/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.5'"
                >verificationEvent/id moet '2.16.840.1.113883.2.4.3.11.5' (XIS-typekwalificatie-id) zijn</assert>
        </rule>
        <rule context="hl7:subject/hl7:QualifiedApplicationRole/hl7:subjectOf2/hl7:verficationEvent/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.3.11.2' and @code='XTK'"
                >verificationEvent/code moet 'XTK' zijn en komen uit '2.16.840.1.113883.2.4.3.11.2' (XIS-typekwalificatietypen)</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/QualifiedApplicationRole/partOf/assignedDevice</title>
        <rule context="hl7:subject/hl7:QualifiedApplicationRole/hl7:partOf/hl7:assignedDevice/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6'"
                >assignedDevice/id/@root moet '2.16.840.1.113883.2.4.6.6' bevatten</assert>
        </rule>
    </pattern>
</schema>
